/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.tools;

import com.inprise.vbroker.compiler.tools.tool;
import com.inprise.vbroker.compiler.util.BufferReader;
import com.inprise.vbroker.compiler.util.BufferWriter;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.compiler.util.Options;
import com.inprise.vbroker.util.Version;

public class ToolOptions
extends Options {
    public String _toolName = null;
    public Class _frontEnd = null;
    public Class _backEnd = null;
    public BufferReader _bufferReader = null;
    public BufferWriter _bufferWriter = null;
    public ErrorReporter _userER = this._ER;
    String frontEndName;
    String backEndName;
    String bufferReaderName;
    String bufferWriterName;
    String errorReporterName;
    boolean printVersion;
    private static final String _evalStampString = "@@@@@@>>>\u0005\u0001\u0001--------------------@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@<<<@@@@@@";
    static Class class$java$lang$String;
    static Class class$com$inprise$vbroker$compiler$util$BufferReader;
    static Class class$com$inprise$vbroker$compiler$util$ErrorReporter;

    public ToolOptions(ErrorReporter ER) {
        super(ER);
    }

    public String[] getUsage() {
        return new String[]{"Comp.Tools.CLflag.frontEndClass", "Comp.Tools.CLflag.backEndClass", "Comp.Tools.CLflag.bufferReaderClass", "Comp.Tools.CLflag.bufferWriterClass", "Comp.Tools.CLflag.errorReporterClass"};
    }

    public String[] parse(String[] flags, boolean[] usageResult) {
        Class bufferWriterClass;
        Class bufferReaderClass;
        Class errorReporterClass;
        block8: for (int i = 0; i < flags.length; ++i) {
            String flag = flags[i];
            if (flag == null) continue;
            if (!flag.startsWith("-")) {
                if (this._toolName != null) continue;
                this._toolName = flag;
                flags[i] = null;
                continue;
            }
            flag = flags[i];
            if (flag == null || (flag = flag.substring(1)).equals("")) continue;
            try {
                switch (flag.charAt(0)) {
                    case 'v': {
                        if (flag.equals("version")) {
                            this.printVersion = true;
                            break;
                        }
                    }
                    case 'f': {
                        if (!flag.equals("fe")) continue block8;
                        this.frontEndName = this.getArg(flags, i);
                        break;
                    }
                    case 'b': {
                        if (flag.equals("be")) {
                            this.backEndName = this.getArg(flags, i);
                            break;
                        }
                        if (flag.equals("br")) {
                            this.bufferReaderName = this.getArg(flags, i);
                            break;
                        }
                        if (!flag.equals("bw")) continue block8;
                        this.bufferWriterName = this.getArg(flags, i);
                        break;
                    }
                    case 'e': {
                        if (!flag.equals("er")) continue block8;
                        this.errorReporterName = this.getArg(flags, i);
                        break;
                    }
                }
                continue;
            }
            catch (IllegalArgumentException e) {
                usageResult[1] = true;
                usageResult[0] = true;
                String[] stringArray = flags;
                return stringArray;
            }
        }
        if (this._toolName == null || this.frontEndName == null) {
            usageResult[1] = true;
            usageResult[0] = true;
            return flags;
        }
        if (this.frontEndName != null) {
            this._frontEnd = tool.getClassForName(this.frontEndName, this._ER, "Comp.Tools.unknownTargetFrontend");
            if (this._frontEnd == null) {
                usageResult[1] = true;
            }
        }
        if (this.backEndName != null) {
            this._backEnd = tool.getClassForName(this.backEndName, this._ER, "Comp.Tools.unknownTargetBackend");
            if (this._backEnd == null) {
                usageResult[1] = true;
            }
        }
        if (this.errorReporterName != null && (errorReporterClass = tool.getClassForName(this.errorReporterName, this._ER, "Comp.Tools.unknownErrorReporter")) != null) {
            this._userER = (ErrorReporter)tool.construct(errorReporterClass, this._ER.getToolName(), new Object[]{"com.inprise.vbroker.compiler.Messages"}, this._ER, new Class[]{class$java$lang$String == null ? (class$java$lang$String = ToolOptions.class$("java.lang.String")) : class$java$lang$String});
            if (this._userER == null) {
                usageResult[1] = true;
            }
        }
        if (this.bufferReaderName != null && (bufferReaderClass = tool.getClassForName(this.bufferReaderName, this._ER, "Comp.Tools.unknownBufferReader")) != null) {
            this._bufferReader = (BufferReader)tool.construct(bufferReaderClass, this._ER.getToolName(), new Object[]{this._userER}, this._ER, new Class[]{class$com$inprise$vbroker$compiler$util$ErrorReporter == null ? (class$com$inprise$vbroker$compiler$util$ErrorReporter = ToolOptions.class$("com.inprise.vbroker.compiler.util.ErrorReporter")) : class$com$inprise$vbroker$compiler$util$ErrorReporter});
            if (this._bufferReader == null) {
                usageResult[1] = true;
            }
        }
        if (this.bufferWriterName != null && (bufferWriterClass = tool.getClassForName(this.bufferWriterName, this._ER, "Comp.Tools.unknownBufferWriter")) != null) {
            this._bufferWriter = (BufferWriter)tool.construct(bufferWriterClass, this._ER.getToolName(), new Object[]{this._userER, this._bufferReader}, this._ER, new Class[]{class$com$inprise$vbroker$compiler$util$ErrorReporter == null ? (class$com$inprise$vbroker$compiler$util$ErrorReporter = ToolOptions.class$("com.inprise.vbroker.compiler.util.ErrorReporter")) : class$com$inprise$vbroker$compiler$util$ErrorReporter, class$com$inprise$vbroker$compiler$util$BufferReader == null ? (class$com$inprise$vbroker$compiler$util$BufferReader = ToolOptions.class$("com.inprise.vbroker.compiler.util.BufferReader")) : class$com$inprise$vbroker$compiler$util$BufferReader});
            if (this._bufferWriter == null) {
                usageResult[1] = true;
            }
        }
        if (this._userER != null) {
            this._userER.setToolName(this._toolName);
            this._userER._verbose = this._ER._verbose;
        }
        if (this.printVersion) {
            this.version();
            usageResult[1] = false;
            usageResult[0] = false;
        }
        return flags;
    }

    protected void version() {
        if (this._ER._verbose) {
            this._ER.print("Comp.Tools.toolVersion", new Object[]{Version.getVersion(_evalStampString)});
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        Version.checkLicense(_evalStampString);
    }
}

